/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.settings.user;

import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.settings.user.BonsaiUserSettings;
import com.ibm.hwmca.fw.settings.user.ConfirmationSettings;
import com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings;
import com.ibm.hwmca.fw.settings.user.UIStyleSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DefaultUserSettings
implements Persistable {
    private static DefaultUserSettings instance;
    private HashMap originalSettings;
    private String backgroundImageName;
    private HashMap changedSettings;
    private static final String TRACE_MASKT = "HUSTDEFT";
    private static final String TRACE_MASKF = "HUSTDEFF";
    private static final String TRACE_MASKD = "HUSTDEFD";

    private DefaultUserSettings() {
    }

    public DefaultUserSettings(PersistentData data, String persistKey) {
        instance = DefaultUserSettings.getDefaultUserSettings();
        instance.setFromPersistent((Persistent)data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static DefaultUserSettings getDefaultUserSettings() {
        block15: {
            Trace.trace(TRACE_MASKT, "-> DefaultUserSettings getDefaultUserSettings()");
            if (instance == null) {
                FileInputStream fis = null;
                File file = new File("data/defaultuserpref.properties");
                Properties properties = new Properties();
                fis = new FileInputStream(file);
                properties.load(fis);
                instance = new DefaultUserSettings();
                DefaultUserSettings.instance.originalSettings = new HashMap();
                DefaultUserSettings.instance.originalSettings.put("com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings", new ObjectBackgroundSettings(properties));
                DefaultUserSettings.instance.originalSettings.put("com.ibm.hwmca.fw.settings.user.ConfirmationSettings", new ConfirmationSettings(properties));
                DefaultUserSettings.instance.originalSettings.put("com.ibm.hwmca.fw.settings.user.UIStyleSettings", new UIStyleSettings(properties));
                DefaultUserSettings.instance.originalSettings.put("com.ibm.hwmca.fw.settings.user.BonsaiUserSettings", new BonsaiUserSettings(properties));
                DefaultUserSettings.instance.backgroundImageName = (String)properties.get("background.image.name");
                PersistenceManager pm = PersistenceManager.getPersistenceManager();
                try {
                    Persistent p = (Persistent)pm.read("com.ibm.hwmca.fw.settings.user.DefaultUserSettings");
                    if (p != null) {
                        instance.setFromPersistent(p);
                    }
                }
                catch (PersistenceException exc) {
                    Trace.trace(TRACE_MASKF, " caught exception " + exc);
                    exc.printStackTrace();
                }
                Object var6_7 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block15;
                }
                catch (IOException exc) {}
                break block15;
                {
                    catch (IOException iOException) {
                        Object var6_8 = null;
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block15;
                        }
                        catch (IOException exc) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException exc) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- DefaultUserSettings getDefaultUserSettings()");
        return instance;
    }

    private void setFromPersistent(Persistent p) {
        Trace.trace(TRACE_MASKF, "<> DefaultUserSettings setFromPersist()");
        if (this.changedSettings == null) {
            this.changedSettings = new HashMap();
        }
        for (int i = 0; i < p.userSettings.length; ++i) {
            this.changedSettings.put(p.userSettings[i].getClass().getName(), p.userSettings[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object settings) {
        Trace.trace(TRACE_MASKF, "<> DefaultUserSettings add(), " + settings);
        boolean result = false;
        String className = settings.getClass().getName();
        DefaultUserSettings defaultUserSettings = this;
        synchronized (defaultUserSettings) {
            if (!this.originalSettings.containsKey(className)) {
                this.originalSettings.put(className, settings);
                result = true;
            }
            this.persist();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replace(Object settings) {
        Trace.trace(TRACE_MASKF, "<> DefaultUserSettings replace(), " + settings);
        boolean result = false;
        String className = settings.getClass().getName();
        DefaultUserSettings defaultUserSettings = this;
        synchronized (defaultUserSettings) {
            if (this.originalSettings.containsKey(className)) {
                if (this.changedSettings == null) {
                    this.changedSettings = new HashMap();
                }
                this.changedSettings.put(className, settings);
                result = true;
            }
            this.persist();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getClassNames() {
        String[] classNames;
        DefaultUserSettings defaultUserSettings = this;
        synchronized (defaultUserSettings) {
            classNames = new String[this.originalSettings.size()];
            Set keys = this.originalSettings.keySet();
            int i = 0;
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                classNames[i++] = (String)iterator.next();
            }
        }
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getUserSettings() {
        Trace.trace(TRACE_MASKF, "-> DefaultUserSettings getUserSettings()");
        HashMap<String, Object> settings = new HashMap<String, Object>();
        DefaultUserSettings defaultUserSettings = this;
        synchronized (defaultUserSettings) {
            Set keys = this.originalSettings.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                Object value = null;
                if (this.changedSettings != null) {
                    value = this.changedSettings.get(next);
                }
                if (value == null) {
                    value = this.originalSettings.get(next);
                }
                settings.put(next, value);
            }
        }
        Trace.trace(TRACE_MASKF, "<- DefaultUserSettings getUserSettings()");
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSettings getUserSettings(String className) {
        Trace.trace(TRACE_MASKF, "-> DefaultUserSettings getUserSettings(), " + className);
        Object settings = null;
        DefaultUserSettings defaultUserSettings = this;
        synchronized (defaultUserSettings) {
            if (this.changedSettings != null) {
                settings = this.changedSettings.get(className);
            }
            if (settings == null) {
                settings = this.originalSettings.get(className);
            }
        }
        Trace.trace(TRACE_MASKF, "<- DefaultUserSettings getUserSettings()");
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getOriginalUserSettings() {
        Trace.trace(TRACE_MASKF, "-> DefaultUserSettings getOriginalUserSettings()");
        HashMap<String, Object> settings = new HashMap<String, Object>();
        DefaultUserSettings defaultUserSettings = this;
        synchronized (defaultUserSettings) {
            Set keys = this.originalSettings.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                settings.put(next, ((UserSettings)this.originalSettings.get(next)).clone());
            }
        }
        Trace.trace(TRACE_MASKF, "<- DefaultUserSettings getOriginalUserSettings()");
        return settings;
    }

    public static String getUIBackgroundImageName() {
        return DefaultUserSettings.getDefaultUserSettings().backgroundImageName;
    }

    public static void setUIBackgroundImageName(String name) {
        DefaultUserSettings.getDefaultUserSettings().backgroundImageName = name;
    }

    private void persist() {
        Trace.trace(TRACE_MASKF, "<> DefaultUserSettings persist()");
        PersistenceManager pm = PersistenceManager.getPersistenceManager();
        try {
            pm.write("com.ibm.hwmca.fw.settings.user.DefaultUserSettings", this.getPersistentData());
        }
        catch (PersistenceException exc) {
            Trace.trace(TRACE_MASKF, " caught exception " + exc);
            exc.printStackTrace();
        }
    }

    public PersistentData getPersistentData() {
        Persistent p = new Persistent();
        UserSettings[] userSettingsArray = new UserSettings[this.changedSettings.size()];
        p.userSettings = this.changedSettings.values().toArray(userSettingsArray);
        return p;
    }

    public boolean isUpgradeData() {
        return true;
    }

    private static class Persistent
    implements PersistentData {
        int version = 0;
        UserSettings[] userSettings;
        private static final long serialVersionUID = -4855588904480282966L;

        private Persistent() {
        }
    }
}

